//
// The Car Carrier \ REVAMPED
// Credits to Shoulen
//

#include <a_samp> // Do not change or remove this

#define COLOR_SUCCESS 0x21F541FF
#define COLOR_FAIL 0xEE2828FF

#define VEHICLE_TRANSPORT 548
#define MAX_CARGOBOBS 20
#define VIRTUAL_WORLD random(100) // Change random(100) to an unused virtual world

// DO NOT EDIT UNDER THIS LINE UNLESS YOU KNOW WHAT YOU ARE DOING

new cargoBobs[MAX_VEHICLES] = 0;
new cargoBobID[MAX_CARGOBOBS];
new cargoBobvID[MAX_VEHICLES];
new cargoBobHasCargo[MAX_CARGOBOBS] = 0;
new cargo_increment;
new Text:cbbg[MAX_CARGOBOBS];
new Text:cbbg2[MAX_CARGOBOBS];
new Text:cbmodel[MAX_CARGOBOBS];

forward CreateTextDraws(cargoid);
forward ShowTextDraws(playerid);
forward HideTextDraws(playerid);

public OnFilterScriptInit()
{
	print("---\nCar Carrier by Shoulen Loaded\n---");
	return 1;
}

//------------------------------------------------
public OnPlayerStateChange(playerid, newstate, oldstate)
{
    if(newstate == PLAYER_STATE_DRIVER && cargoBobs[GetPlayerVehicleID(playerid)] == 1) // Player entered a cargobob as driver
    {
		ShowTextDraws(playerid);
    }
}

public OnPlayerExitVehicle(playerid, vehicleid)
{
	HideTextDraws(playerid);
}

public OnPlayerKeyStateChange(playerid, newkeys, oldkeys)
{
	#define PRESSED(%0) \
	(((newkeys & (%0)) == (%0)) && ((oldkeys & (%0)) != (%0)))
	if (PRESSED(KEY_FIRE))
	{
		if (GetPlayerVehicleSeat(playerid) == 0 && cargoBobHasCargo[cargoBobs[GetPlayerVehicleID(playerid)]] > 0)	{
		    new Float:x, Float:y, Float:z, Float:za;
			GetVehiclePos(GetPlayerVehicleID(playerid), x, y, z);
			SetVehiclePos(cargoBobHasCargo[cargoBobs[GetPlayerVehicleID(playerid)]], x, y-10, z);
			GetVehicleZAngle(GetPlayerVehicleID(playerid), za);
			SetVehicleZAngle(cargoBobHasCargo[cargoBobs[GetPlayerVehicleID(playerid)]], za);
			SetVehicleVirtualWorld(cargoBobHasCargo[cargoBobs[GetPlayerVehicleID(playerid)]], GetPlayerVirtualWorld(playerid));
			cargoBobHasCargo[cargoBobs[GetPlayerVehicleID(playerid)]] = 0;
 			TextDrawHideForPlayer(playerid, cbmodel[cargoBobvID[GetPlayerVehicleID(playerid)]]);
			TextDrawSetPreviewModel(cbmodel[cargoBobvID[GetPlayerVehicleID(playerid)]], 18862);
			TextDrawShowForPlayer(playerid, cbmodel[cargoBobvID[GetPlayerVehicleID(playerid)]]);
		}
	}
}

public OnPlayerCommandText(playerid, cmdtext[])
{
	if(strcmp("/carcarrier", cmdtext, true) == 0)
	{
		if(GetPlayerVehicleSeat(playerid) == 0) {
	        if(GetVehicleModel(GetPlayerVehicleID(playerid)) == VEHICLE_TRANSPORT) { // Player is in Cargobob
	            if(cargoBobs[GetPlayerVehicleID(playerid)] == 0) {
	                cargo_increment++;
					cargoBobs[GetPlayerVehicleID(playerid)] = 1;
					cargoBobvID[GetPlayerVehicleID(playerid)] = cargo_increment;
					cargoBobID[cargo_increment] = GetPlayerVehicleID(playerid);
					SendClientMessage(playerid, COLOR_SUCCESS, "Car Carrier mode enabled");
					CreateTextDraws(cargo_increment);
					ShowTextDraws(playerid);
				} else {
  	                cargo_increment--;
					cargoBobs[GetPlayerVehicleID(playerid)] = 0;
					cargoBobvID[GetPlayerVehicleID(playerid)] = 0;
					SendClientMessage(playerid, COLOR_SUCCESS, "Car Carrier mode disabled");
					HideTextDraws(playerid);
				}
			} else {
					SendClientMessage(playerid, COLOR_FAIL, "You are not in a car carrier");
			}
  		} else {
		    SendClientMessage(playerid, COLOR_FAIL, "You need to be in the driver seat of a car carrier");
		}
		return 1;
	}
	if(strcmp("/carload", cmdtext, true) == 0)
	{
	    if(GetPlayerVehicleSeat(playerid) == 0 && GetVehicleModel(GetPlayerVehicleID(playerid)) != 548) {
			new Float:x, Float:y, Float:z;
			for(new i; i < MAX_CARGOBOBS; i++) { // The loop of all carriers (default 20)
			    if(cargoBobs[cargoBobID[i]] == 1) { // If a carrier is found to exist
			        GetVehiclePos(cargoBobID[i], x, y, z);
					if(IsPlayerInRangeOfPoint(playerid, 15.0, x, y, z)) { // If player is in range of found carrier
	    				if(cargoBobHasCargo[i] == 0) { // If it has no cargo
						    new Veh = GetPlayerVehicleID(playerid);
							RemovePlayerFromVehicle(playerid);
							SetVehicleVirtualWorld(Veh, VIRTUAL_WORLD);
							cargoBobHasCargo[cargoBobs[cargoBobID[i]]] = Veh;
							TextDrawSetPreviewModel(cbmodel[cargoBobs[cargoBobID[i]]], GetVehicleModel(Veh));
						} else {
						    SendClientMessage(playerid, COLOR_FAIL, "There is already a vehicle inside this car carrier");
						}
						break;
					}
				}
			}
		} else {
		    SendClientMessage(playerid, COLOR_FAIL, "You need to be in the driver seat of a vehicle");
		}
		return 1;
	}
	return 0;
}

public CreateTextDraws(cargoid) {

    cbbg[cargoid] = TextDrawCreate(560.000000, 350.000000, "_");
	TextDrawAlignment(cbbg[cargoid], 2);
	TextDrawBackgroundColor(cbbg[cargoid], 255);
	TextDrawFont(cbbg[cargoid], 1);
	TextDrawLetterSize(cbbg[cargoid], 0.500000, 9.000000);
	TextDrawColor(cbbg[cargoid], -1);
	TextDrawSetOutline(cbbg[cargoid], 0);
	TextDrawSetProportional(cbbg[cargoid], 1);
	TextDrawSetShadow(cbbg[cargoid], 1);
	TextDrawUseBox(cbbg[cargoid], 1);
	TextDrawBoxColor(cbbg[cargoid], 255);
	TextDrawTextSize(cbbg[cargoid], 0.000000, 140.000000);

	cbbg2[cargoid] = TextDrawCreate(560.000000, 340.000000, "_");
	TextDrawAlignment(cbbg2[cargoid], 2);
	TextDrawBackgroundColor(cbbg2[cargoid], 255);
	TextDrawFont(cbbg2[cargoid], 1);
	TextDrawLetterSize(cbbg2[cargoid], 0.500000, 11.000000);
	TextDrawColor(cbbg2[cargoid], 16711935);
	TextDrawSetOutline(cbbg2[cargoid], 0);
	TextDrawSetProportional(cbbg2[cargoid], 1);
	TextDrawSetShadow(cbbg2[cargoid], 1);
	TextDrawUseBox(cbbg2[cargoid], 1);
	TextDrawBoxColor(cbbg2[cargoid], 100);
	TextDrawTextSize(cbbg2[cargoid], 0.000000, 150.000000);

	cbmodel[cargoid] = TextDrawCreate(520.000000, 350.000000, "_");
	TextDrawAlignment(cbmodel[cargoid], 2);
	TextDrawBackgroundColor(cbmodel[cargoid], 255);
	TextDrawFont(cbmodel[cargoid], 5);
	TextDrawLetterSize(cbmodel[cargoid], -0.289999, -3.000000);
	TextDrawColor(cbmodel[cargoid], -1);
	TextDrawSetOutline(cbmodel[cargoid], 0);
	TextDrawSetProportional(cbmodel[cargoid], 1);
	TextDrawSetShadow(cbmodel[cargoid], 1);
	TextDrawTextSize(cbmodel[cargoid], 70.000000, 80.000000);
	TextDrawSetPreviewModel(cbmodel[cargoid], 18862);
	TextDrawSetPreviewRot(cbmodel[cargoid], -16.000000, 0.000000, -55.000000, 1.000000);
	TextDrawSetSelectable(cbmodel[cargoid], 0);

}

public ShowTextDraws(playerid)
{
	if(cargoBobHasCargo[cargoBobvID[GetPlayerVehicleID(playerid)]] == 0) {
		TextDrawSetPreviewModel(cbmodel[cargoBobvID[GetPlayerVehicleID(playerid)]], 18862); //
	}
	TextDrawShowForPlayer(playerid, cbmodel[cargoBobvID[GetPlayerVehicleID(playerid)]]);

	TextDrawShowForPlayer(playerid, cbbg[cargoBobvID[GetPlayerVehicleID(playerid)]]);
	TextDrawShowForPlayer(playerid, cbbg2[cargoBobvID[GetPlayerVehicleID(playerid)]]);

}

public HideTextDraws(playerid)
{
	TextDrawHideForPlayer(playerid, cbbg[cargoBobvID[GetPlayerVehicleID(playerid)]]);
	TextDrawHideForPlayer(playerid, cbbg2[cargoBobvID[GetPlayerVehicleID(playerid)]]);
	TextDrawHideForPlayer(playerid, cbmodel[cargoBobvID[GetPlayerVehicleID(playerid)]]);
}


